## ** 1. Choosing a Supplicant**

You can choose between two main options for 802.1X supplicants:

1. **Cisco Secure Client with Network Access Manager (NAM)**:
    
    - Advanced EAP support (e.g., EAP-FAST, EAP-TTLS, EAP-TLS, PEAP).
    - Supports machine and user authentication in a single process (via EAP Chaining).
    - Supports MACsec (AES-GCM-256 encryption).
    - Partially managed via Network Access Manager Profile Editor.
    - Requires a separate license.
2. **Native OS Supplicant (Microsoft Windows)**:
    
    - Supports EAP methods like EAP-TLS, PEAP, and EAP-TEAP.
    - Machine and user authentication supported (via EAP Chaining with EAP-TEAP).
    - Centralized management via Microsoft Active Directory Group Policies or MDM systems.
    - Included in the operating system (no additional cost).

---

## **2. 802.1X Windows Client Authentication**

Windows hosts in an Active Directory domain can use the following authentication options:

1. **Machine Authentication**:
    - Logs the machine into the network using Active Directory credentials before a user logs in.
    - Useful for applying GPOs, scripts, and updates.
2. **User Authentication**:
    - Authenticates the user after they log in.
    - Connection terminates when the user logs out unless configured otherwise.
3. **Machine and User Authentication**:
    - Combines machine authentication (when no user is logged in) with user authentication (when a user logs in).
    - Recommended for trusted enterprise-owned devices.

### **Best Practices:**

- Use at least machine authentication to ensure connectivity for domain updates and policies.
- Combine machine and user authentication for visibility and differentiated access.
- Use **EAP Chaining** with EAP-FAST (Cisco Secure Client) or EAP-TEAP (Microsoft Native Supplicant) for the most scalable and flexible authentication.

### **EAP Chaining Benefits**:

- Allows Cisco ISE to evaluate multiple combinations:
    - Both machine and user authentication succeed.
    - Only machine or only user authentication succeeds.
    - Neither succeeds.
- Enables differentiated policies for enterprise and non-enterprise devices.

---

## **3. Configuring the Microsoft Windows Supplicant**

### **Steps to Configure the Windows 10 Supplicant**:

1. **Install Certificates**:
    
    - **CA Root Certificate**: Install in the trusted root store for server-side certificate validation.
    - **Client Certificate** (if needed): Install in the machine or user certificate store for client-side authentication.
2. **Start the Wired AutoConfig Service**:
    
    - Open **services.msc** from the Run menu.
    - Start the **Wired AutoConfig** service to enable 802.1X on Ethernet interfaces.
3. **Enable and Configure 802.1X Authentication**:
    
    - Open the properties of the network adapter.
    - Configure the **Authentication** tab (enabled after Wired AutoConfig is started):
        - Enable **IEEE 802.1X authentication**.
        - Save credentials for the connection.
        - Enable fallback support for inaccessible authentication bypass if needed.
        - Select and configure the EAP method (e.g., EAP-TLS, PEAP-MSCHAPv2):
            - Enable **server certificate validation**.
            - Select trusted CA root certificates for validation.
        - Choose machine, user, or both for authentication.

---

## **4. Key Recommendations**

- **Enable Machine Authentication**:
    - Ensures domain connectivity and infrastructure access before user logins.
- **Use EAP Chaining for Scalability**:
    - Combine machine and user authentication in one EAP session.
- **Enforce Certificate Validation**:
    - Reject untrusted authentication servers to prevent rogue server attacks.
- **Start Wired AutoConfig Service**:
    - Essential for enabling 802.1X on Windows wired interfaces.
- **Use Group Policies for Centralized Management**:
    - Simplifies certificate deployment and supplicant configuration across enterprise devices.

---

### **Conclusion**

Choosing and configuring the right 802.1X supplicant depends on your organization's needs for EAP support, authentication flexibility, and management. Cisco Secure Client offers advanced features like MACsec and EAP-FAST, while the Microsoft native supplicant integrates seamlessly with Active Directory and is cost-effective. Properly configuring the supplicant ensures secure and reliable network access for wired clients.